# R is a free, object oriented, statistical software
# Dowload: http://cran.r-project.org/


#-------------------Libraries for dose-response curves---------------------------------------------------------

# Libraries in R specialised on analysis of dose-response curves


library(drc)   	  # Analysis of dose-response curves
               	  # http://www.bioassay.dk/
                  # R version  2.3.0
# in progress
library(drfit) 	  # Dose-response data evaluation
                  # http://cran.r-project.org/
# also usefull
library(multcomp) # The multcomp package allows for multiple comparisons of k groups in general linear models.
                  # angina - dose response data

#-------------------Library drc---------------------------------------------------------
# Read library
library(drc)

############## Read data FA ##############################
data(FA)
FA
help(FA)
plot(MEANLR~MM,data=FA,xlab="Dose",ylab="Response",main="FA data")


# Fitting a 4-parameter logistic model
##  with Box-Cox transformation
model_FA_l4 <- multdrc(FA, boxcox = TRUE)  
summary(model_FA_l4)
plot(model_FA_l4)
ED(model_FA_l4,c(10,50,90))

# Brain-Cousens modification of logistic function
model_FA_BC <- multdrc(FA, fct=braincousens(fixed=c(NA, NA, NA, NA, NA),lowerc=c(1, -Inf, -Inf, -Inf, -Inf)), control=mdControl(constr=TRUE))
summary(model_FA_BC)
plot(model_FA_BC)
ED(model_FA_BC,c(10,50,90))





















